### The PlayerOneCamera SDK on Mac OS

#### Universal macOS library
libPlayerOneCamera.dylib is Universal library, it supports x86_64 architecture and Apple silicon.

#### The libPlayerOneCamera.dylib relies on libusb-1.0.0.dylib

The dependency path of libusb-1.0.0.dylib is `@rpath/libusb-1.0.0.dylib`, You can view it using the ‘otool’ command. So, If your Mac have not libusb, here is how to install libusb on your Mac OS.

#### Install libusb using Homebrew

If Homebrew is not installed on your Mac, please visit <https://brew.sh/>.
Or Paste the following command in a macOS Terminal：

```bash
/bin/bash -c "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)"
```

Use the following command to install libusb：

```bash
brew install libusb
```

#### Install libusb by compiling the source code

Please visit the libusb website <https://libusb.info/> and download the latest source code, and then uncompress it.
Run the following commands in turn in macOS Terminal：

```bash
./configure

make

make install
```

The libusb-1.0.0.dylib and its header will be installed to /usr/local/

#### Change the dependency path of libusb

The libusb dependency path of the SDK can be checked by the command `otool -L libPlayerOneCamera.dylib`, it is `@rpath/libusb-1.0.0.dylib`.

If your APP carries libusb itself, you can change the libusb dependency path, use the following command:

```bash
#Suppose that you put libusb-1.0.0.dylib in the YOUR_APP/Contents/Frameworks/
install_name_tool -change "@rpath/libusb-1.0.0.dylib" "@executable_path/../Frameworks/libusb-1.0.0.dylib" "libPlayerOneCamera.dylib"
#or
install_name_tool -change "@rpath/libusb-1.0.0.dylib" "@loader_path/libusb-1.0.0.dylib" "libPlayerOneCamera.dylib"
```
