# -*- coding: utf-8 -*-
import time
import sys
import pyPOAFilterWheel as PWLib

Wheel_Handle = 0
Wheel_Error = PWLib.PWErrors.PW_OK
Wheel_Opened = 0
Position_Count = 0

# get wheel API version and SDK version
APIver = PWLib.GetPWAPIVer()
print("APIver:",APIver)

SDKver = PWLib.GetPWSDKVer()
print("SDKver:",SDKver)

# ----------------get wheel count----------------
Wheel_Count = PWLib.GetPWCount()
print("Connected POA Wheel Count:",Wheel_Count)

if Wheel_Count <= 0:
    sys.exit(0)
    
# displays the properties of all wheels
for i in range(0, Wheel_Count):
    print("-------------------------------------")
    print("the property of filter wheel(index: {})".format(i))
    Wheel_Error, wheelProp = PWLib.GetPWProperties(i)
    if Wheel_Error != PWLib.PWErrors.PW_OK:
        print("get property failed, error: ", PWLib.GetPWErrorString(Wheel_Error)) # display the error
        continue
    
    print("Name: ", wheelProp.Name.decode('utf-8'))
    print("Handle: ", wheelProp.Handle)
    print("PositionCount: ", wheelProp.PositionCount)
    print("SN: ", wheelProp.SN.decode('utf-8'))
    
# ----------------operate the first wheel----------------
Wheel_Error, wheelProp = PWLib.GetPWProperties(0)
Wheel_Handle = wheelProp.Handle
Position_Count = wheelProp.PositionCount
# open the wheel
Wheel_Error = PWLib.OpenPW(Wheel_Handle)
if Wheel_Error != PWLib.PWErrors.PW_OK:
    print("open wheel failed, error: ", PWLib.GetPWErrorString(Wheel_Error))
    sys.exit(0)
    
print("open wheel OK, Handle: ", Wheel_Handle)
    
# NOTE: When opened successfully, wheel will goto 1st position
# detect wheel is moving
while True:
    Wheel_Error, wheelState = PWLib.GetPWState(Wheel_Handle) # waiting for wheel stop moving
    if wheelState != PWLib.PWState.PW_STATE_MOVING:
        break
    
Wheel_Error, position = PWLib.GetCurrentPosition(Wheel_Handle) # get wheel current position
print("wheel current position: ", position+1) # position is index, start from 0

print("-------------------------------------")
print("start wheel goto test...")
isPosIncreased = True
while True:
    while True:
        Wheel_Error, wheelState = PWLib.GetPWState(Wheel_Handle) # waiting for wheel stop moving
        if wheelState != PWLib.PWState.PW_STATE_MOVING:
            break
     
    if isPosIncreased:
        position += 1
    else:
        position -= 1
           
    if position < 0:
        break
    elif position >= Position_Count:
        isPosIncreased = False
        position = Position_Count - 1
        continue
           
    print("wheel is moving to {} position...".format(position+1)) # position is index, start from 0
    Wheel_Error = PWLib.GotoPosition(Wheel_Handle, position)
    print("goto position: ", PWLib.GetPWErrorString(Wheel_Error))

print("-------------------------------------")
# set and get one way
isOneWay = True
Wheel_Error = PWLib.SetOneWay(Wheel_Handle, isOneWay)
print("set one way: ", PWLib.GetPWErrorString(Wheel_Error))
Wheel_Error, isUnidirectional = PWLib.GetOneWay(Wheel_Handle)
print("get one way: ", PWLib.GetPWErrorString(Wheel_Error))
print("is one way: ", isUnidirectional)

print("-------------------------------------")   
# set filter alias and focus offset
for i in range(0, Position_Count):
    print("set filter alias and focus offset, position: ", i)
    strFilterAlias = f"filter_{i}" # max length is MAX_NAME_LEN, if want to clear alias, strFilterAlias = ""
    Wheel_Error = PWLib.SetPWFilterAlias(Wheel_Handle, i, strFilterAlias)
    print("set filter alias: ", PWLib.GetPWErrorString(Wheel_Error))
    time.sleep(0.05) # this is a recommended action to relieve pressure on the wheel hardware
    
    focusOffset = 100+i # if want to no focus offset, focusOffset = 0
    Wheel_Error = PWLib.SetPWFocusOffset(Wheel_Handle, i, focusOffset)
    print("set focus offset: ", PWLib.GetPWErrorString(Wheel_Error))
    time.sleep(0.05)

print("-------------------------------------")    
# get filter alias and focus offset
for i in range(0, Position_Count):
    print("get filter alias and focus offset, position: ", i)
    Wheel_Error, strFilterAlias = PWLib.GetPWFilterAlias(Wheel_Handle, i)
    print("get filter alias: ", PWLib.GetPWErrorString(Wheel_Error))
    print("the filter alias: ", strFilterAlias)
    time.sleep(0.05) # this is a recommended action to relieve pressure on the wheel hardware
    
    Wheel_Error, focusOffset = PWLib.GetPWFocusOffset(Wheel_Handle, i)
    print("get focus offset: ", PWLib.GetPWErrorString(Wheel_Error))
    print("the focus offset: ", focusOffset)
    time.sleep(0.05) 
 
print("-------------------------------------")
# set custom name for wheel
strCustomName = f"Gear1_{Position_Count}P" # max length is MAX_NAME_LEN, if want to clear custom name, strCustomName = ""
Wheel_Error = PWLib.SetPWCustomName(Wheel_Handle, strCustomName)
print("set wheel custom name: ", PWLib.GetPWErrorString(Wheel_Error))

# get custom from wheel
Wheel_Error, customName = PWLib.GetPWCustomName(Wheel_Handle)
print("get wheel custom name: ", PWLib.GetPWErrorString(Wheel_Error))
print("the custom name of wheel is : ", customName)
Wheel_Error, wheelProp = PWLib.GetPWPropertiesByHandle(Wheel_Handle)
print("the name of wheel show as :", wheelProp.Name.decode('utf-8'))

print("-------------------------------------")
# if the wheel has an error, please try resetting it
# Wheel_Error = PWLib.ResetPW(Wheel_Handle)
# print("reset wheel: ", PWLib.GetPWErrorString(Wheel_Error))
# print("wait for the reset to complete...")
# while True:
#     Wheel_Error, wheelState = PWLib.GetPWState(Wheel_Handle) # waiting for wheel stop moving
#     if wheelState != PWLib.PWState.PW_STATE_MOVING:
#         break

print("-------------------------------------")   
Wheel_Error = PWLib.ClosePW(Wheel_Handle) # close the wheel
print("close the wheel: ", PWLib.GetPWErrorString(Wheel_Error))