#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "PlayerOnePW.h"

int main()
{
    // get wheel API version and SDK version
    printf("API Ver: %d \n", POAGetPWAPIVer());
    printf("SDK Ver: %s \n", POAGetPWSDKVer());

    printf("-------------------------------------\n");
    int PW_count = POAGetPWCount();

    printf("PW count: %d\n", PW_count);
    if(PW_count <= 0)
    {
        printf("there is no Player One filter wheel! \n");

        getchar();

        return 0;
    }

    //malloc pointer memory first
    PWProperties **ppPOA_PW_Prop = (PWProperties **)malloc(sizeof(PWProperties *) * PW_count);

    int i;
    for(i = 0; i < PW_count; i++)
    {
        ppPOA_PW_Prop[i] = (PWProperties *)malloc(sizeof (PWProperties)); //malloc the PWProperties memory

        PWErrors error = POAGetPWProperties(i, ppPOA_PW_Prop[i]);

        if(error == PW_OK)
        {
            //print PW Handle and Name
            printf("PW Handle: %d, PW name: %s \n", ppPOA_PW_Prop[i]->Handle, ppPOA_PW_Prop[i]->Name);
            //print PW SN and PW position count
            printf("PW SN: %s \n PW Position Count: %d \n", ppPOA_PW_Prop[i]->SN, ppPOA_PW_Prop[i]->PositionCount);
        }
        else
        {
            free(ppPOA_PW_Prop[i]);
            ppPOA_PW_Prop[i] = NULL;
            printf("get PW properties failed, index: %d, error code: %s \n", i, POAGetPWErrorString(error));
        }
    }

    printf("-------------------------------------\n");

    //operate the first wheel

    int handle, position_count, goto_position;

    handle = ppPOA_PW_Prop[0]->Handle;

    position_count = ppPOA_PW_Prop[0]->PositionCount;

    // open PW
    PWErrors error;
    error = POAOpenPW(handle);

    if(error != PW_OK)
    {
        printf("Open PW Failed, error code: %s \n", POAGetPWErrorString(error));

        //free the memory
        for(i = 0; i < PW_count; i++)
        {
            if(ppPOA_PW_Prop[i])
            {
                free(ppPOA_PW_Prop[i]);
                ppPOA_PW_Prop[i] = NULL;
            }
        }

        free(ppPOA_PW_Prop);
        ppPOA_PW_Prop = NULL;

        return 0;
    }

    printf("open wheel OK, Handle: %d \n", handle);

    printf("-------------------------------------\n");
    //NOTE: When opened successfully, phoenix filter wheel will goto 1st position,menas: index == 0;

    //Detect PW is moving
    //You can ignore this step in your APP, in this demo, just waiting for PW stop moving
    PWState pw_state = PW_STATE_OPENED;
    do
    {
        POAGetPWState(handle, &pw_state);
    }while(pw_state == PW_STATE_MOVING);

    //get the current position
    goto_position = 0;
    error = POAGetCurrentPosition(handle, &goto_position);
    printf("get PW current position, pos: %d, error code: %s \n \n", goto_position, POAGetPWErrorString(error));

    printf("Goto Poistion Testing: \n");

    do
    {
        printf("--> Please input a number in the range[0 - %d], if the number < 0, this Goto Poistion Testing will quit: \n", position_count-1);
        scanf("%d", &goto_position);

        if(goto_position < 0)
        {
            printf("goto poistion testing quit.... \n");
            break;
        }

        if(goto_position >= position_count)
        {
            printf("The number you inputed is out of range.... \n");
            continue;
        }

        error = POAGotoPosition(handle, goto_position); // goto position

        printf("got position: %d, error string: %s \n", goto_position, POAGetPWErrorString(error));

        if(error == PW_OK) //waiting for PW stop moving
        {
            PWState pw_state = PW_STATE_OPENED;

            do
            {
                POAGetPWState(handle, &pw_state);
            }while(pw_state == PW_STATE_MOVING);
        }

    }while(1);

    printf("-------------------------------------\n");
    // set one-way
    error = POASetOneWay(handle, 1); // enable one-way, 0 means not one-way, 1 means one-way
    printf("set one way: %s \n", POAGetPWErrorString(error));
    // get one way
    int isOneWay = 0;
    error = POAGetOneWay(handle, &isOneWay);
    printf("get one way: %s \n", POAGetPWErrorString(error));
    printf("is one way: %d \n", isOneWay);

    printf("-------------------------------------\n");
    // set filter alias and focus offset
    int pos, time;
    for (pos = 0; pos < position_count; pos++)
    {
        printf("set filter alias and focus offset, position: %d \n", pos);
        char filterAlias[MAX_NAME_LEN];
        memset(filterAlias, 0, MAX_NAME_LEN);
        sprintf(filterAlias, "%s_%d", "filter", pos);
        error = POASetPWFilterAlias(handle, pos, filterAlias, MAX_NAME_LEN); // if want to clear alias, POASetPWFilterAlias(handle, pos, "", 0)
        printf("set filter alias: %s \n", POAGetPWErrorString(error));
        for(time = 0; time < 100000; time++); // recommended, similar to the sleep() function, relieve pressure on filter wheel hardware

        int focus_offset = 1000 + pos;
        error = POASetPWFocusOffset(handle, pos, focus_offset); // want to set no focus offset, POASetPWFocusOffset(handle, pos, 0)
        printf("set focus offset: %s \n", POAGetPWErrorString(error));
        for(time = 0; time < 100000; time++); // recommended, similar to the sleep() function, relieve pressure on filter wheel hardware
    }

    printf("-------------------------------------\n");
    //get filter alias and focus offset
    for (pos = 0; pos < position_count; pos++)
    {
        printf("get filter alias and focus offset, position: %d \n", pos);
        char filterAlias[MAX_NAME_LEN];
        memset(filterAlias, 0, MAX_NAME_LEN);
        error = POAGetPWFilterAlias(handle, pos, filterAlias, MAX_NAME_LEN);
        printf("get filter alias: %s \n", POAGetPWErrorString(error));
        printf("the filter alias is: %s \n", filterAlias);
        for(time = 0; time < 100000; time++); // recommended, similar to the sleep() function, relieve pressure on filter wheel hardware

        int focus_offset = 0;
        error = POAGetPWFocusOffset(handle, pos, &focus_offset);
        printf("get focus offset: %s \n", POAGetPWErrorString(error));
        printf("the focus offset is: %d \n", focus_offset);
        for(time = 0; time < 100000; time++); // recommended, similar to the sleep() function, relieve pressure on filter wheel hardware
    }

    printf("-------------------------------------\n");
    // set custom name for wheel
    char custom_name[MAX_NAME_LEN];
    memset(custom_name, 0, MAX_NAME_LEN);
    sprintf(custom_name, "%s_%dP", "Gear1", position_count);
    error = POASetPWCustomName(handle, custom_name, MAX_NAME_LEN);
    printf("set wheel custom name: %s \n", POAGetPWErrorString(error));

    // get custom from wheel
    memset(custom_name, 0, MAX_NAME_LEN);
    error = POAGetPWCustomName(handle, custom_name, MAX_NAME_LEN);
    printf("get wheel custom name: %s \n", POAGetPWErrorString(error));
    printf("the custom name is: %s \n", custom_name);
    PWProperties * PW_Prop = (PWProperties *)malloc(sizeof (PWProperties)); //malloc the PWProperties memory
    POAGetPWPropertiesByHandle(handle, PW_Prop); // get current wheel name
    printf("the name of wheel show as : %s \n", PW_Prop->Name);
    free(PW_Prop);
    PW_Prop = NULL;

    printf("-------------------------------------\n");
    //if the wheel has an error, please try resetting it
    error = POAResetPW(handle);
    printf("reset wheel: %s \n", POAGetPWErrorString(error));
    printf("wait for the reset to complete... \n");

    pw_state = PW_STATE_OPENED;
    do
    {
        POAGetPWState(handle, &pw_state); // waiting for wheel stop moving
    }while(pw_state == PW_STATE_MOVING);

    printf("-------------------------------------\n");
    //Close PW
    error = POAClosePW(handle);
    printf("close the wheel: %s \n", POAGetPWErrorString(error));

    //free the memory
    for(i = 0; i < PW_count; i++)
    {
        if(ppPOA_PW_Prop[i])
        {
            free(ppPOA_PW_Prop[i]);
            ppPOA_PW_Prop[i] = NULL;
        }
    }

    free(ppPOA_PW_Prop);
    ppPOA_PW_Prop = NULL;

    return 0;
}
